<?php
/*
Template Name: News
*/
?>

<?php get_header(); ?>

	<div id="content" class="narrowcolumn" role="main">
		<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                        
                <div <?php post_class(); ?> id="post-<?php the_ID(); ?>">
                    <h2><?php the_title(); ?></h2>
                </div>
    
            <?php endwhile; ?>

                    <?php
					$display_categories = array(9);
					foreach ($display_categories as $category) { ?>
						<?php query_posts("showposts=-1&cat=$category");
						$wp_query->is_category = false;
						$wp_query->is_page = true;
						$wp_query->is_home = true;
						
						if (have_posts()) : ?>                                                
                            <?php while (have_posts()) : the_post(); ?>
                                <div <?php post_class(); ?> id="post-<?php the_ID(); ?>">
                                    <a href="<?php the_permalink() ?>" rel="bookmark" title="<?php printf(__('Permanent Link to %s', 'kubrick'), the_title_attribute('echo=0')); ?>">
									<?php the_post_thumbnail('thumbnail'); ?>
                                    <h3><?php the_title(); ?></h3>
                                    <div class="entry">
                                        <?php the_excerpt(); ?>
                                    </div>
                                    </a>
                                </div>
                            <?php endwhile; ?>
						<?php endif; ?>
					<?php } ?>

        <?php else : ?>
            <h2 class="center"><?php _e('Not Found', 'kubrick'); ?></h2>
            <p class="center"><?php _e('Sorry, but you are looking for something that isn&#8217;t here.', 'kubrick'); ?></p>
            <?php get_search_form(); ?>
        <?php endif; ?>

	</div>

<?php get_sidebar(); ?>
<?php get_footer(); ?>
