<?php
/**
 * TwentyTen functions and definitions
 */


if ( ! function_exists( 'twentyten_setup' ) ):
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 *
 * To override twentyten_setup() in a child theme, add your own twentyten_setup to your child theme's
 * functions.php file.
 *
 * @uses add_theme_support() To add support for post thumbnails, custom headers and backgrounds, and automatic feed links.
 * @uses register_nav_menus() To add support for navigation menus.
 * @uses add_editor_style() To style the visual editor.
 * @uses load_theme_textdomain() For translation/localization support.
 * @uses register_default_headers() To register the default custom header images provided with the theme.
 * @uses set_post_thumbnail_size() To set a custom post thumbnail size.
 *
 * @since Twenty Ten 1.0
 */
function twentyten_setup() {

	// This theme styles the visual editor with editor-style.css to match the theme style.
	add_editor_style();
}
endif;

add_filter('tiny_mce_before_init', 'juiz_custom_block_select');  
    if ( !function_exists('juiz_custom_block_select')) :  
        function juiz_custom_block_select($settings) {  
            // on retire `adress`, `h1` et `h2`  
            $settings['theme_advanced_blockformats'] = 'h3,h4,h5';  
            return $settings;  
         }
		 endif;